package test

import (
	"fmt"
	"github.com/gruntwork-io/terratest/modules/random"
	"github.com/gruntwork-io/terratest/modules/terraform"
	"testing"
)

func TestMySqlExample(t *testing.T) {
	t.Parallel()

	terraformOptions := &terraform.Options{
		// Powinieneś uaktualnić tę względną ścieżkę dostępu,
    // aby prowadziła do katalogu examples!
		TerraformDir: "../examples/mysql",
		Vars: map[string]interface{}{
			"db_name":     fmt.Sprintf("test_%s", random.UniqueId()),
			"db_username": "admin",
			"db_password": "password",
		},
	}

	defer terraform.Destroy(t, terraformOptions)
	terraform.InitAndApply(t, terraformOptions)
}
